<?php

/**
 * @file
 * Bartik's theme implementation to display a single Drupal page.
 *
 * The doctype, html, head and body tags are not in this template. Instead they
 * can be found in the html.tpl.php template normally located in the
 * modules/system directory.
 *
 * Available variables:
 *
 * General utility variables:
 * - $base_path: The base URL path of the Drupal installation. At the very
 *   least, this will always default to /.
 * - $directory: The directory the template is located in, e.g. modules/system
 *   or themes/bartik.
 * - $is_front: TRUE if the current page is the front page.
 * - $logged_in: TRUE if the user is registered and signed in.
 * - $is_admin: TRUE if the user has permission to access administration pages.
 *
 * Site identity:
 * - $front_page: The URL of the front page. Use this instead of $base_path,
 *   when linking to the front page. This includes the language domain or
 *   prefix.
 * - $logo: The path to the logo image, as defined in theme configuration.
 * - $site_name: The name of the site, empty when display has been disabled
 *   in theme settings.
 * - $site_slogan: The slogan of the site, empty when display has been disabled
 *   in theme settings.
 * - $hide_site_name: TRUE if the site name has been toggled off on the theme
 *   settings page. If hidden, the "element-invisible" class is added to make
 *   the site name visually hidden, but still accessible.
 * - $hide_site_slogan: TRUE if the site slogan has been toggled off on the
 *   theme settings page. If hidden, the "element-invisible" class is added to
 *   make the site slogan visually hidden, but still accessible.
 *
 * Navigation:
 * - $main_menu (array): An array containing the Main menu links for the
 *   site, if they have been configured.
 * - $secondary_menu (array): An array containing the Secondary menu links for
 *   the site, if they have been configured.
 * - $breadcrumb: The breadcrumb trail for the current page.
 *
 * Page content (in order of occurrence in the default page.tpl.php):
 * - $title_prefix (array): An array containing additional output populated by
 *   modules, intended to be displayed in front of the main title tag that
 *   appears in the template.
 * - $title: The page title, for use in the actual HTML content.
 * - $title_suffix (array): An array containing additional output populated by
 *   modules, intended to be displayed after the main title tag that appears in
 *   the template.
 * - $messages: HTML for status and error messages. Should be displayed
 *   prominently.
 * - $tabs (array): Tabs linking to any sub-pages beneath the current page
 *   (e.g., the view and edit tabs when displaying a node).
 * - $action_links (array): Actions local to the page, such as 'Add menu' on the
 *   menu administration interface.
 * - $feed_icons: A string of all feed icons for the current page.
 * - $node: The node object, if there is an automatically-loaded node
 *   associated with the page, and the node ID is the second argument
 *   in the page's path (e.g. node/12345 and node/12345/revisions, but not
 *   comment/reply/12345).
 *
 * Regions:
 * - $page['header']: Items for the header region.
 * - $page['featured']: Items for the featured region.
 * - $page['highlighted']: Items for the highlighted content region.
 * - $page['help']: Dynamic help text, mostly for admin pages.
 * - $page['content']: The main content of the current page.
 * - $page['sidebar_first']: Items for the first sidebar.
 * - $page['triptych_first']: Items for the first triptych.
 * - $page['triptych_middle']: Items for the middle triptych.
 * - $page['triptych_last']: Items for the last triptych.
 * - $page['footer_firstcolumn']: Items for the first footer column.
 * - $page['footer_secondcolumn']: Items for the second footer column.
 * - $page['footer_thirdcolumn']: Items for the third footer column.
 * - $page['footer_fourthcolumn']: Items for the fourth footer column.
 * - $page['footer']: Items for the footer region.
 *
 * @see template_preprocess()
 * @see template_preprocess_page()
 * @see template_process()
 * @see bartik_process_page()
 * @see html.tpl.php
 */
?>
<?php $themePath =  base_path() . path_to_theme(); ?>

<!-- Page-->
    <div class="page text-center">
      <!-- Page Header-->
      <header class="page-head">
	  <?php print render($page['header']); ?>
        <!-- RD Navbar-->
        <div class="rd-navbar-wrap rd-navbar-default">
          <nav data-layout="rd-navbar-fixed" data-sm-layout="rd-navbar-fixed" data-md-layout="rd-navbar-fixed" data-md-device-layout="rd-navbar-fixed" data-lg-layout="rd-navbar-fixed" data-lg-device-layout="rd-navbar-fixed" data-xl-layout="rd-navbar-sidebar" data-xl-device-layout="rd-navbar-sidebar" data-stick-up-clone="false" data-md-stick-up-offset="100px" data-lg-stick-up-offset="100px" data-auto-height="true" class="rd-navbar">
            <div class="shell shell-fluid">
              <div class="rd-navbar-inner">
                <!-- RD Navbar Panel-->
                <div class="rd-navbar-panel">
                  <!-- RD Navbar Toggle-->
                  <button data-rd-navbar-toggle=".rd-navbar-nav-wrap" class="rd-navbar-toggle"><span></span></button>
                  <!-- RD Navbar Brand--><a href="index.html" class="rd-navbar-brand brand">
                    <div class="brand-logo"><img src="<?php print $themePath; ?>/images/brand-186x65.png" alt="" width="186" height="65"/>
                    </div></a>
                </div>
                <!-- RD Navbar Nav-->
                <div class="rd-navbar-nav-wrap">
                  <!-- RD Navbar Brand--><a href="index.html" class="rd-navbar-brand brand">
                    <div class="brand-logo"><img src="<?php print $themePath; ?>/images/brand-186x65.png" alt="" width="186" height="65"/>
                    </div></a>
                  <!-- RD Navbar Shop-->
                  <div class="rd-navbar-shop"><a href="shop-cart.html" class="link link-shop link-default"><span class="big text-gray-light">Cart</span><span class="icon icon-sm mdi mdi-cart-outline"></span><span class="label-inline big">2</span></a></div>
                  <!-- RD Navbar Nav-->
                  <ul class="rd-navbar-nav">
                    <li class="active"><a href="index.html">Home</a>
                    </li>
                    <li><a href="about.html">About Us</a>
                    </li>
                    <li><a href="menu-modern.html">Menu</a>
                      <!-- RD Navbar Dropdown-->
                      <ul class="rd-navbar-dropdown">
                        <li><a href="menu-single.html">Breakfast</a>
                        </li>
                        <li><a href="menu-single.html">Lunch</a>
                        </li>
                        <li><a href="menu-single.html">Salads</a>
                        </li>
                        <li><a href="menu-single.html">Cakes</a>
                        </li>
                        <li><a href="menu-single.html">Drinks</a>
                        </li>
                        <li><a href="menu-single.html">Catering</a>
                        </li>
                      </ul>
                    </li>
                    <li><a href="#">Pages</a>
                      <!-- RD Navbar Megamenu-->
                      <ul class="rd-navbar-megamenu">
                        <li>
                          <h6 class="rd-megamenu-header">Pages</h6>
                          <ul class="list-marked">
                            <li><a href="careers.html">Careers</a></li>
                            <li><a href="faq.html">FAQ</a></li>
                            <li><a href="deals.html">Deals</a></li>
                            <li><a href="coming-soon.html">Coming Soon</a></li>
                            <li><a href="404.html">404 Page</a></li>
                            <li><a href="503.html">503 Page</a></li>
                            <li><a href="search-results.html">Search Result</a></li>
                            <li><a href="maintenance.html">Maintenance Page</a></li>
                            <li><a href="privacy.html">Terms of Use</a></li>
                            <li><a href="member-profile.html">Member profile</a></li>
                            <li><a href="team.html">Our Team</a></li>
                            <li><a href="testimonials.html">Testimonials</a></li>
                          </ul>
                        </li>
                        <li>
                          <h6 class="rd-megamenu-header">Additional Pages</h6>
                          <ul class="list-marked">
                            <li><a href="typography.html">Typography</a></li>
                            <li><a href="buttons.html">Buttons</a></li>
                            <li><a href="forms.html">Forms</a></li>
                            <li><a href="icons.html">Icons</a></li>
                            <li><a href="grid.html">Grid</a></li>
                            <li><a href="tabs-and-accordions.html">Tabs &amp; Accordions</a></li>
                            <li><a href="progress-bars.html">Progress Bars</a></li>
                            <li><a href="tables.html">Tables</a></li>
                            <li><a href="login-register.html">Login/Register </a></li>
                          </ul>
                        </li>
                        <li>
                          <h6 class="rd-megamenu-header">Menu</h6>
                          <ul class="list-marked">
                            <li><a href="menu-classic.html">Classic Menu</a></li>
                            <li><a href="menu-modern.html">Modern Menu</a></li>
                            <li><a href="menu-single.html">Single Menu</a></li>
                            <li><a href="shop-single.html">Product Single</a></li>
                            <li><a href="shop-cart.html">Cart page</a></li>
                          </ul>
                        </li>
                      </ul>
                    </li>
                    <li><a href="#">Gallery</a>
                      <!-- RD Navbar Dropdown-->
                      <ul class="rd-navbar-dropdown">
                        <li><a href="gallery-grid.html">Grid Gallery</a>
                        </li>
                        <li><a href="gallery-cobbles.html">Cobbles Gallery</a>
                        </li>
                        <li><a href="gallery-masonry.html">Masonry Gallery</a>
                        </li>
                        <li><a href="gallery-condensed.html">Grid without Padding</a>
                        </li>
                      </ul>
                    </li>
                    <li><a href="contacts.html">Contacts</a>
                    </li>
                    <li><a href="#">News</a>
                      <!-- RD Navbar Dropdown-->
                      <ul class="rd-navbar-dropdown">
                        <li><a href="blog-classic.html">Classic Blog</a>
                        </li>
                        <li><a href="blog-grid.html">Grid Blog</a>
                        </li>
                        <li><a href="blog-masonry.html">Masonry Blog</a>
                        </li>
                        <li><a href="blog-modern.html">Modern Blog</a>
                        </li>
                        <li><a href="blog-post.html">Single Post</a>
                        </li>
                      </ul>
                    </li>
                  </ul>
                  <div class="rd-navbar-aside-right">
                    <ul class="list-links list-inline text-left">
                      <li>
                        <div class="unit unit-horizontal unit-middle unit-spacing-xs">
                          <div class="unit-left"><span class="icon icon-circle icon-burnt-sienna icon-xxs mdi mdi-map-marker text-middle"></span></div>
                          <div class="unit-body">
                            <address class="contact-info"><a href="#" class="link-default link-xs">267 Park Avenue <br class="visible-md visible-lg"> New York, NY 90210</a></address>
                          </div>
                        </div>
                      </li>
                      <li>
                        <div class="unit unit-horizontal unit-middle unit-spacing-xs">
                          <div class="unit-left"><span class="icon icon-circle icon-burnt-sienna icon-xxs mdi mdi-phone text-middle"></span></div>
                          <div class="unit-body">
                            <address class="contact-info"><a href="callto:#" class="link-default link-xs">1-800-1234-567</a><span class="reveal-block text-base link-xs">Mon – Sat: 9:00–18:00</span></address>
                          </div>
                        </div>
                      </li>
                      <li>
                        <ul class="list-inline list-inline-sm">
                          <li><a href="#" class="link-silver-light"><span class="icon icon-sm-mod-1 fa fa-instagram"></span></a></li>
                          <li><a href="#" class="link-silver-light"><span class="icon icon-sm-mod-1 fa fa-facebook"></span></a></li>
                          <li><a href="#" class="link-silver-light"><span class="icon icon-sm-mod-1 fa fa-twitter"></span></a></li>
                          <li><a href="#" class="link-silver-light"><span class="icon icon-sm-mod-1 fa fa-google-plus"></span></a></li>
                        </ul>
                      </li>
                    </ul>
                  </div>
                </div>

              </div>
            </div>
          </nav>
        </div>
      </header>
      <!-- Page Content-->
      <main class="page-content">
        <!-- Swiper variant 3-->
		 <?php if ($page['homepageslider']): ?>
        <section class="bg-gray-darker">
          <?php print render($page['homepageslider']); ?>
        </section>
		<?php endif; ?>
        <section class="section-50 section-sm-100 bg-ecru-white">
          <div class="shell-wide">
            <div class="range range-xs-center">
			<?php if ($page['homefeatured']): ?>
			<div class="cell-sm-10 cell-md-6 view-animate zoomInSmall delay-04">
			<?php print render($page['homefeatured']); ?>
			  </div>
			<?php endif; ?>
			
            <?php if ($page['homefeatured2']): ?>
			<div class="cell-sm-10 cell-md-6 offset-top-50 offset-md-top-0">
			<?php print render($page['homefeatured2']); ?>
			  </div>
			<?php endif; ?>
 
            </div>
          </div>
        </section>
		
		 <?php print render($page['content']); ?>
      </main>
      <!-- Page Footer-->
      <footer class="page-foot text-center footer-light">
        <section class="section-top-45 section-bottom-45">
          <div class="shell">
            <ul class="list list-inline list-footer-nav">
              <li><a href="menu-single.html" class="text-uppercase">Breakfast</a></li>
              <li><a href="menu-single.html" class="text-uppercase">Lunch</a></li>
              <li><a href="menu-single.html" class="text-uppercase">Salads</a></li>
              <li><a href="menu-single.html" class="text-uppercase">Cakes</a></li>
              <li><a href="menu-single.html" class="text-uppercase">Drinks</a></li>
              <li><a href="menu-single.html" class="text-uppercase">Catering</a></li>
            </ul>
          </div>
        </section>
        <section>
          <div class="shell">
            <hr>
          </div>
          <div class="shell section-20">
            <div class="range range-xs-center">
              <div class="cell-md-5">
                <p class="copyright">
                  VeganFood
                  &nbsp;&#169;&nbsp;<span id="copyright-year"></span>&nbsp;<br class="veil-sm"><a href="privacy.html">Privacy Policy</a>
                </p>
              </div>
            </div>
          </div>
        </section>

      </footer>
    </div>
    <!-- Global Mailform Output-->
    <div id="form-output-global" class="snackbars"></div>
    <!-- PhotoSwipe Gallery-->
    <div tabindex="-1" role="dialog" aria-hidden="true" class="pswp">
      <div class="pswp__bg"></div>
      <div class="pswp__scroll-wrap">
        <div class="pswp__container">
          <div class="pswp__item"></div>
          <div class="pswp__item"></div>
          <div class="pswp__item"></div>
        </div>
        <div class="pswp__ui pswp__ui--hidden">
          <div class="pswp__top-bar">
            <div class="pswp__counter"></div>
            <button title="Close (Esc)" class="pswp__button pswp__button--close"></button>
            <button title="Share" class="pswp__button pswp__button--share"></button>
            <button title="Toggle fullscreen" class="pswp__button pswp__button--fs"></button>
            <button title="Zoom in/out" class="pswp__button pswp__button--zoom"></button>
            <div class="pswp__preloader">
              <div class="pswp__preloader__icn">
                <div class="pswp__preloader__cut">
                  <div class="pswp__preloader__donut"></div>
                </div>
              </div>
            </div>
          </div>
          <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
            <div class="pswp__share-tooltip"></div>
          </div>
          <button title="Previous (arrow left)" class="pswp__button pswp__button--arrow--left"></button>
          <button title="Next (arrow right)" class="pswp__button pswp__button--arrow--right"></button>
          <div class="pswp__caption">
            <div class="pswp__caption__cent"></div>
          </div>
        </div>
      </div>
    </div>
